import crypto from "crypto";

const otpStore = new Map(); // (In prod use Redis/DB)

export const generateOTP = (nationalId) => {
  const otp = Math.floor(100000 + Math.random() * 900000).toString(); // 6-digit
  otpStore.set(nationalId, {
    otp,
    expires: Date.now() + 5 * 60 * 1000 // 5 min expiry
  });
  return otp;
};

export const verifyOTP = (nationalId, otp) => {
  const record = otpStore.get(nationalId);
  if (!record) return false;
  if (record.otp === otp && Date.now() < record.expires) {
    otpStore.delete(nationalId);
    return true;
  }
  return false;
};
